#ifdef SKINNING

uniform mat4 	boneMatrices[100],
	     	prevBoneMatrices[100];
attribute vec4	weights;
attribute vec4 	matrixIndices;

#endif

varying float 		distance;
varying vec2 		texcoord;	
uniform float 		maxdist,
			mindist;
varying float 		depth;
uniform mat4		prevMVM,
			WTM;
varying vec4 		pos,prev;

void main()
{
#ifdef SKINNING

	vec4 prevpos = vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 position = vec4( 0.0, 0.0, 0.0, 0.0 );

  	position = position + ((boneMatrices[int(matrixIndices.x)] * gl_Vertex) * weights.x);
	position = position + ((boneMatrices[int(matrixIndices.y)] * gl_Vertex) * weights.y);
	position = position + ((boneMatrices[int(matrixIndices.z)] * gl_Vertex) * weights.z);
	position = position + ((boneMatrices[int(matrixIndices.w)] * gl_Vertex) * weights.w);
	gl_Position = gl_ModelViewProjectionMatrix * position;

	prevpos = prevpos + ((prevBoneMatrices[int(matrixIndices.x)] * gl_Vertex) * weights.x);
	prevpos = prevpos + ((prevBoneMatrices[int(matrixIndices.y)] * gl_Vertex) * weights.y);
	prevpos = prevpos + ((prevBoneMatrices[int(matrixIndices.z)] * gl_Vertex) * weights.z);
	prevpos = prevpos + ((prevBoneMatrices[int(matrixIndices.w)] * gl_Vertex) * weights.w);
	prev = gl_ProjectionMatrix*prevMVM*prevpos;

#else

	gl_Position = ftransform();
	mat4 MVP=gl_ProjectionMatrix*prevMVM*WTM;
	prev=MVP*gl_Vertex;

#endif

	texcoord=gl_MultiTexCoord0.xy;	

	float dist=(gl_Position.z-mindist)/(maxdist-mindist);
	distance=1.0 - (clamp(dist,0.0,1.0));
	depth=gl_Position.z;

	pos=gl_Position;
}